unit MWMapMain;

{
  Demonstrate use of the TXMLTransformProvider component for converting
  between arbitrary XML documents and Delphi's client dataset format.

  Copyright  Keith Wood (kbwood@iprimus.com.au)
  Written 8 September, 2002.
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, xmldom, DB, DBClient, Provider, Xmlxform, StdCtrls, DBCtrls,
  ExtCtrls, Grids, DBGrids, ComCtrls;

type
  TfrmMWMap = class(TForm)
    pgcMovieWatcher: TPageControl;
      tabMovies: TTabSheet;
        grdMovies: TDBGrid;
        Panel1: TPanel;
        navMovies: TDBNavigator;
        Splitter1: TSplitter;
        grdStars: TDBGrid;
        Panel2: TPanel;
        navStars: TDBNavigator;
      tabCinemas: TTabSheet;
        grdCinemas: TDBGrid;
        Panel3: TPanel;
        navCinemas: TDBNavigator;
        Splitter2: TSplitter;
        grdPrices: TDBGrid;
        Panel4: TPanel;
        navPrices: TDBNavigator;
      tabScreenings: TTabSheet;
        grdScreenings: TDBGrid;
        Panel5: TPanel;
        navScreenings: TDBNavigator;
        Splitter3: TSplitter;
        grdSessions: TDBGrid;
        Panel6: TPanel;
        navSessions: TDBNavigator;
    btnApply: TButton;
    btnCancel: TButton;
    btnSave: TButton;
    prvTransform: TXMLTransformProvider;
    cdsMovieWatcher: TClientDataSet;
      cdsMovieWatcherid: TStringField;
      cdsMovieWatchermovie: TDataSetField;
      cdsMovieWatchercinema: TDataSetField;
      cdsMovieWatcherscreening: TDataSetField;
    cdsMovies: TClientDataSet;
      cdsMoviesid: TStringField;
      cdsMoviesrating: TStringField;
      cdsMovieslogourl: TStringField;
      cdsMoviesurl: TStringField;
      cdsMoviesname: TStringField;
      cdsMovieslength: TIntegerField;
      cdsMoviesdirector: TStringField;
      cdsMoviessynopsis: TStringField;
      cdsMoviesstar: TDataSetField;
    srcMovies: TDataSource;
    cdsStars: TClientDataSet;
      cdsStarsstar: TStringField;
    srcStars: TDataSource;
    cdsCinemas: TClientDataSet;
      cdsCinemasid: TStringField;
      cdsCinemasname: TStringField;
      cdsCinemasphone: TStringField;
      cdsCinemasaddress: TStringField;
      cdsCinemasdirections: TStringField;
      cdsCinemascandybar: TStringField;
      cdsCinemasdisabledaccess: TStringField;
      cdsCinemasprices: TDataSetField;
    srcCinemas: TDataSource;
    cdsPrices: TClientDataSet;
      cdsPricesid: TStringField;
      cdsPricesname: TStringField;
      cdsPricesperiod: TStringField;
      cdsPricesadult: TFloatField;
      cdsPriceschild: TFloatField;
      cdsPricesdiscount: TFloatField;
    srcPrices: TDataSource;
    cdsPricesLookup: TClientDataSet;
    cdsScreenings: TClientDataSet;
      cdsScreeningsmovieid: TStringField;
      cdsScreeningscinemaid: TStringField;
      cdsScreeningsstartdate: TDateField;
      cdsScreeningsenddate: TDateField;
      cdsScreeningsdigitalsound: TStringField;
      cdsScreeningsnopasses: TStringField;
      cdsScreeningssessions: TDataSetField;
      cdsScreeningsmoviename: TStringField;
      cdsScreeningscinemaname: TStringField;
    srcScreenings: TDataSource;
    cdsSessions: TClientDataSet;
      cdsSessionssession: TTimeField;
      cdsSessionspriceid: TStringField;
      cdsSessionspricename: TStringField;
    srcSessions: TDataSource;
    procedure FormCreate(Sender: TObject);
    procedure cdsScreeningsAfterScroll(DataSet: TDataSet);
    procedure btnApplyClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
  private
  public
  end;

var
  frmMWMap: TfrmMWMap;

implementation

{$R *.dfm}

{ Initialisation. }
procedure TfrmMWMap.FormCreate(Sender: TObject);
begin
  pgcMovieWatcher.ActivePage := tabMovies;
  // Create the pricing lookup dataset
  with cdsPricesLookup do
  begin
    CreateDataSet;
    cdsCinemas.First;
    while not cdsCinemas.Eof do
    begin
      cdsPrices.First;
      while not cdsPrices.Eof do
      begin
        Insert;
        FieldByName('cinema-id').AsString  := cdsCinemasid.AsString;
        FieldByName('price-id').AsString   := cdsPricesid.AsString;
        FieldByName('price-name').AsString := cdsPricesname.AsString;
        Post;
        cdsPrices.Next;
      end;
      cdsCinemas.Next;
    end;
    Open;
    cdsCinemas.First;
  end;
  // And attach it to the sessions dataset
  cdsSessions.Close;
  with cdsSessionspricename do
  begin
    LookupDataSet     := cdsPricesLookup;
    LookupKeyFields   := 'price-id';
    LookupResultField := 'price-name';
  end;
  cdsSessions.Open;
  cdsScreenings.AfterScroll := cdsScreeningsAfterScroll;
  cdsScreeningsAfterScroll(cdsScreenings);
end;

{ Filter available pricings based on current cinema. }
procedure TfrmMWMap.cdsScreeningsAfterScroll(DataSet: TDataSet);
begin
  cdsPricesLookup.Filter :=
    '[cinema-id] = ''' + cdsScreeningscinemaid.AsString + '''';
  try
    cdsSessions.Refresh;
  except on E: EDatabaseError do
    // Ignore
  end;
end;

{ Apply all accumulated updates and write out to the XML document. }
procedure TfrmMWMap.btnApplyClick(Sender: TObject);

  procedure CheckDataSet(const DataSet: TClientDataSet);
  begin
    if DataSet.State in dsEditModes then
      DataSet.Post;
  end;

begin
  CheckDataSet(cdsSessions);
  CheckDataSet(cdsScreenings);
  CheckDataSet(cdsPrices);
  CheckDataSet(cdsCinemas);
  CheckDataSet(cdsStars);
  CheckDataSet(cdsMovies);
  cdsMovieWatcher.ApplyUpdates(-1);
end;

{ Cancel any accumulated updates. }
procedure TfrmMWMap.btnCancelClick(Sender: TObject);
begin
  cdsMovieWatcher.CancelUpdates;
end;

{ Save the client dataset datapacket. }
procedure TfrmMWMap.btnSaveClick(Sender: TObject);
begin
  cdsMovieWatcher.SaveToFile('MWDataPacket.xml', dfXML);
  MessageDlg('Saved to MWDataPacket.xml', mtInformation, [mbOK], 0);
end;

end.
